<%@ page import="java.io.*, java.util.*"%>

<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib uri="http://beehive.apache.org/netui/tags-databinding-1.0" prefix="netui-data"%>
<%@ taglib uri="http://beehive.apache.org/netui/tags-html-1.0" prefix="netui"%>
<%@ taglib uri="http://beehive.apache.org/netui/tags-template-1.0" prefix="netui-template"%>
<%@ taglib uri="http://www.bea.com/servers/portal/tags/ad" prefix="ad"%>
<%@taglib uri="http://www.bea.com/servers/portal/tags/content" prefix="cm"%>
<%@ taglib uri="http://bea.com/struts/adapter/tags-nested" prefix="nested"%>

<%@page import="java.util.Map"%>
<%@page import="java.util.HashMap"%>

<%/*
    This is ugly last minute code, don't blame me.  An enhancement request to build a real help system has been created.

    Essentially, this is the help system.  If a single help file is requested, which is
    done by passing in the parameter "helpDirectRequest", this file will be displayed.

    Otherwise, this help can be invoked from the header of the portal, passing in pageLabel as the
    "helpForPortalPage" parameter, and we will attempt to render the corresponding help file(s).  For
    SEI pages, there are 7 files that follow a common naming convention.

*/%>



<netui:html>
    <head>
        <title>
            My HealtheVet Help
        </title>
    <link  href="<%=request.getContextPath()%>/framework/skins/default/css/custom-mhv.css" rel="stylesheet" type="text/css">
    <link href="<%=request.getContextPath()%>/framework/skins/default/css/body.css" rel="stylesheet" type="text/css" />
    <style type="text/css">
     .mhv-help-extra-padding{   /* style added to this file only to add padding around the edges of the pop up*/
       padding: 20px;
    }
    </style>
    </head>
    <body class="bea-portal-body">
    <div class="mhv-help-extra-padding">
	  <img src="<%=request.getContextPath()%>/resources/images/logo_myhealthevet_plain.gif" width="220" height="51" alt="MyHealtheVet Logo" />
        <p>
            <%
                String helpRootDir = "/BEA Repository/help/";
                String helpDefaultFile = helpRootDir + "help_default.htm";

                //This junk is for the SEI help, which follows standard naming scheme
                Map seiHelpPageMap = new HashMap();
                seiHelpPageMap.put("activityJournal","activity-journal");
                seiHelpPageMap.put("allergies","allergies");
                seiHelpPageMap.put("bloodPressure","blood-pressure");
                seiHelpPageMap.put("bloodSugar","blood-sugar");
                seiHelpPageMap.put("bodyTemperature","body-temp");
                seiHelpPageMap.put("bodyWeight","body-weight");
                seiHelpPageMap.put("cholesterol","cholesterol");
                seiHelpPageMap.put("ice","emergency-cont");
                seiHelpPageMap.put("familyHealthHistory","fhh");
                seiHelpPageMap.put("foodJournal","food-journal");
                seiHelpPageMap.put("providersAndPhysicians","hc-provider");
                seiHelpPageMap.put("healthInsurance","health-ins");
                seiHelpPageMap.put("heartRate","heart-rate");
                seiHelpPageMap.put("immunization","immunizations");
                seiHelpPageMap.put("medicalEvents","medical-events");
                seiHelpPageMap.put("medsOTCHerbalsSupplements","medications");
                seiHelpPageMap.put("militaryHealthHistory","military-health");
                seiHelpPageMap.put("pain","pain");
                seiHelpPageMap.put("pulseOximetry","pulse-ox");
                seiHelpPageMap.put("tests","tests");
                seiHelpPageMap.put("treatmentLocations","treatment-loc");

                 //This junk is for other mapped help pages
                Map rxRefillHelpPageMap = new HashMap();
                rxRefillHelpPageMap.put("refillPrescriptions","rxrefill");
                rxRefillHelpPageMap.put("prescriptionsHiso","rxhistory");

                //This junk is for other mapped help pages
                Map miscHelpPageMap = new HashMap();
                miscHelpPageMap.put("learnAboutPodCasts","help_podcast.html");
                miscHelpPageMap.put("accountHome","help_change-password.html");
                miscHelpPageMap.put("forgotPassword","help_forgot-password.html");
                miscHelpPageMap.put("forgotUserName","help_forgot-uid.html");
                miscHelpPageMap.put("profilesHome","help_manage-account.html");
                miscHelpPageMap.put("registrationHome","help_registration.html");
                miscHelpPageMap.put("rxRefillHome","help_rxrefill.html");
                miscHelpPageMap.put("pastMedicalHistory","health-summary.html");

                miscHelpPageMap.put("registerHome","help_spam_blocker.html");
                miscHelpPageMap.put("registerHome","ssn_benefits_for_va_patients.htm");
                miscHelpPageMap.put("registerHome","ssn_why_provide.htm");
                
                miscHelpPageMap.put("medicationsInformation","blended_medication_summary.html");
                miscHelpPageMap.put("medicationsInformation","blended_medication_sei.html");
                miscHelpPageMap.put("medicationsInformation","blended_medication_summary-pf.html");
                
                miscHelpPageMap.put("downloadData","help_downloadData-summary.html");
                miscHelpPageMap.put("learnMoreDownloadData","help_downloadData-learnMore.html");
                miscHelpPageMap.put("learnMoreBBDodMilitary","help_downloadData_MSI-learnMore.html");
                miscHelpPageMap.put("faqDodMilitaryService","MOS_faq.htm");
                
                miscHelpPageMap.put("protectDownloadDataHealthInfo","help_downloadData-protectYourHealthInfo.html");
                miscHelpPageMap.put("downloadDataFeatures","help_downloadData-features.html");
                miscHelpPageMap.put("learnMoreImmunizations","help_Immunizations-learnMore.html");
                miscHelpPageMap.put("learnMoreDownloadDataRefresh","help_downloadData-dataRefresh.html");
            %>




            <%if(request.getParameter("helpDirectRequest") != null){
                //SPECIFIC HELP PAGE WAS REQUESTED
                String helpPage = helpRootDir + request.getParameter("helpDirectRequest");
            %>
                <cm:getNode id ="node" path = "<%=helpPage%>"/>
                <nested:notEmpty name="node">
                    <ad:render id="node"/>
                </nested:notEmpty>
                <nested:empty name="node">
                    Requested help file could not be found.
                </nested:empty>


            <%} else { //NO PECIFIC HELP PAGE WAS REQUESTED, REQUESTED HELP IS FOR A GIVEN PORTAL PAGE
                String helpForPortalPage = request.getParameter("helpForPortalPage");

                    //HELP IS FOR SEI's, WHICH FOLLOW A NAMING CONVENTION.
                    //WE MUST CONSOLIDATE LOW LEVEL HELP PAGES
                    if (helpForPortalPage != null && seiHelpPageMap.containsKey(helpForPortalPage)){
                        String seiHelp = (String)seiHelpPageMap.get(helpForPortalPage);
                        String seiHelpAdd = helpRootDir + seiHelp + "_add.html";
                        String seiHelpDelete = helpRootDir + seiHelp +  "_delete.html";
                        String seiHelpDetails = helpRootDir + seiHelp +  "_details.html";
                        String seiHelpDetailsPF = helpRootDir + seiHelp +  "_details-pf.html";
                        String seiHelpEdit = helpRootDir + seiHelp +  "_edit.html";
                        String seiHelpSummary = helpRootDir + seiHelp +  "_summary.html";
                        String seiHelpSummaryPF = helpRootDir + seiHelp +  "_summary-pf.html";
            %>
                        <cm:getNode id ="node" path = "<%=seiHelpSummary%>"/>
                        <nested:notEmpty name="node">
                            <ad:render id="node"/>
                        </nested:notEmpty>
                        <nested:empty name="node">
                            Requested help file <strong><%=seiHelpSummary%></strong> could not be found.
                        </nested:empty><br />

                        <cm:getNode id ="node" path = "<%=seiHelpSummaryPF%>"/>
                        <nested:notEmpty name="node">
                            <ad:render id="node"/>
                        </nested:notEmpty>
                        <nested:empty name="node">
                            Requested help file <strong><%=seiHelpSummaryPF%></strong> could not be found.
                        </nested:empty><br />

                        <cm:getNode id ="node" path = "<%=seiHelpDetails%>"/>
                        <nested:notEmpty name="node">
                            <ad:render id="node"/>
                        </nested:notEmpty>
                        <nested:empty name="node">
                            Requested help file <strong><%=seiHelpDetails%></strong> could not be found.
                        </nested:empty><br />

                        <cm:getNode id ="node" path = "<%=seiHelpDetailsPF%>"/>
                        <nested:notEmpty name="node">
                            <ad:render id="node"/>
                        </nested:notEmpty>
                        <nested:empty name="node">
                            Requested help file <strong><%=seiHelpDetailsPF%></strong> could not be found.
                        </nested:empty><br />

                        <cm:getNode id ="node" path = "<%=seiHelpAdd%>"/>
                        <nested:notEmpty name="node">
                            <ad:render id="node"/>
                        </nested:notEmpty>
                        <nested:empty name="node">
                            Requested help file <strong><%=seiHelpAdd%></strong> could not be found.
                        </nested:empty><br />

                        <cm:getNode id ="node" path = "<%=seiHelpEdit%>"/>
                        <nested:notEmpty name="node">
                            <ad:render id="node"/>
                        </nested:notEmpty>
                        <nested:empty name="node">
                            Requested help file <strong><%=seiHelpEdit%></strong> could not be found.
                        </nested:empty><br />

                        <cm:getNode id ="node" path = "<%=seiHelpDelete%>"/>
                        <nested:notEmpty name="node">
                            <ad:render id="node"/>
                        </nested:notEmpty>
                        <nested:empty name="node">
                            Requested help file <strong><%=seiHelpDelete%></strong> could not be found.
                        </nested:empty>


           <%       //THIS IS A RX REFILL HELP PAGE
                    //FOR RX REFILL, WE CONCAT MULTIPLE HELP FILES FOLLOWING COMMON NAMING CONVENTION
                    } else if(helpForPortalPage != null && rxRefillHelpPageMap.containsKey(helpForPortalPage)){
                        String rxHelp = (String)rxRefillHelpPageMap.get(helpForPortalPage);
                        String rxHelpSummary = helpRootDir + rxHelp + "_summary.html";
                        String rxHelpSummaryPF = helpRootDir + rxHelp +  "_summary-pf.html";
                        String rxHelpDetails = helpRootDir + rxHelp +  "_details.html";
                        String rxHelpDetailsPF = helpRootDir + rxHelp +  "_details-pf.html";
            %>
                        <cm:getNode id ="node" path = "<%=rxHelpSummary%>"/>
                        <nested:notEmpty name="node">
                            <ad:render id="node"/>
                        </nested:notEmpty>
                        <nested:empty name="node">
                            Requested help file <strong><%=rxHelpSummary%></strong> could not be found.
                        </nested:empty>

                        <cm:getNode id ="node" path = "<%=rxHelpSummaryPF%>"/>
                        <nested:notEmpty name="node">
                            <ad:render id="node"/>
                        </nested:notEmpty>
                        <nested:empty name="node">
                            Requested help file <strong><%=rxHelpSummaryPF%></strong> could not be found.
                        </nested:empty>

                        <cm:getNode id ="node" path = "<%=rxHelpDetails%>"/>
                        <nested:notEmpty name="node">
                            <ad:render id="node"/>
                        </nested:notEmpty>
                        <nested:empty name="node">
                            Requested help file <strong><%=rxHelpDetails%></strong> could not be found.
                        </nested:empty>

                        <cm:getNode id ="node" path = "<%=rxHelpDetailsPF%>"/>
                        <nested:notEmpty name="node">
                            <ad:render id="node"/>
                        </nested:notEmpty>
                        <nested:empty name="node">
                            Requested help file <strong><%=rxHelpDetailsPF%></strong> could not be found.
                        </nested:empty>


            <%       //THIS IS A MISC, SIMPLE 1-to-1 MAPPED HELP PAGE
                    } else if(helpForPortalPage != null && miscHelpPageMap.containsKey(helpForPortalPage)){
                        String miscMappedHelpPage = helpRootDir + (String)miscHelpPageMap.get(helpForPortalPage);
            %>
                        <cm:getNode id ="node" path = "<%=miscMappedHelpPage%>"/>
                        <nested:notEmpty name="node">
                            <ad:render id="node"/>
                        </nested:notEmpty>
                        <nested:empty name="node">
                            Requested help file <strong><%=miscMappedHelpPage%></strong> could not be found.
                        </nested:empty>

            <%      //NOTHING REQUESTED, OR REQUEST NOT MAPPED TO SPECIFIC HELP FILE, SHOW A DEFAULT HELP INDEX
                    } else {
            %>
                        <cm:getNode id ="node" path = "<%=helpDefaultFile%>"/>
                        <nested:notEmpty name="node">
                            <ad:render id="node"/>
                        </nested:notEmpty>
                        <nested:empty name="node">
                            Requested help file <strong><%=helpDefaultFile%></strong> could not be found.
                        </nested:empty>
            <%
                    }
            }
            %>

        </p>

        <div class="mhv-align-right">
        <script language="JavaScript">
		  document.write('<input type="button" class="mhv-input-button" value="Close" onClick="self.close();">');
		</script>
		<noscript>
		  <em>To close this window, click the X at the top right corner.</em>
		</noscript>
		</div>
		</div>
    </body>
</netui:html>